//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Collections;
using System.Collections.Specialized;

namespace FrameworkLibraries
{
	public class CollectionsUtilMain 
	{
		static void Main(string [] args)
		{
			Hashtable ht = CollectionsUtil.CreateCaseInsensitiveHashtable();
			ht.Add("Pierwszy", "To jest pierwszy element");
			ht.Add("Drugi", "To jest drugi element");
			ht.Add("Trzeci", "To jest trzeci element");
			ht.Add("Czwarty", "To jest czwarty element");
			ht.Add("Pity", "To jest pity element");
			foreach(DictionaryEntry de in ht)
			{
				Console.WriteLine("{0} {1}", de.Key, de.Value);
			}
			Console.WriteLine("Zawiera \"pierwszy\": {0}", ht.Contains("pierwszy"));
			Console.WriteLine("Zawiera \"szsty\": {0}", ht.Contains("szsty"));
			Console.WriteLine("ht[\"PIERWSZY\"]: \"{0}\"", ht["PIERWSZY"]);

			// Teraz posortowana lista niewraliwa na wielko liter
			SortedList sl = CollectionsUtil.CreateCaseInsensitiveSortedList();
			sl.Add("Pierwszy", "To jest pierwszy element");
			sl.Add("Drugi", "To jest drugi element");
			sl.Add("Trzeci", "To jest trzeci element");
			sl.Add("Czwarty", "To jest czwarty element");
			sl.Add("Pity", "To jest pity element");

			foreach(DictionaryEntry de in sl)
			{
				Console.WriteLine("\"{0}\" {1}", de.Key, de.Value);
			}
			Console.WriteLine("Zawiera \"pierwszy\": {0}", sl.Contains("pierwszy"));
			Console.WriteLine("Zawiera \"szsty\": {0}", sl.Contains("szsty"));
			Console.WriteLine("sl[\"PIERWSZY\"]: \"{0}\"", sl["PIERWSZY"]);

		}
	}
}